Test_BasicBodies = class()

function Test_BasicBodies:init()
    self.title = "basic bodies (tap to create)"
    self.unit = WIDTH * 0.15
end

function Test_BasicBodies:setup()
    self.lab = PhysicsLab()  
    self.lab:makePetrieDish()
    self.lab:boxAt(WIDTH*0.25, self.unit * 3, self.unit, self.unit)
    self.lab:circleAt(WIDTH*0.5, self.unit, self.unit * 0.4)
    self.lab:randomPolygonAt(WIDTH*0.75, self.unit * 3, self.unit * 0.6, self.unit * 0.7)
    print("There are two basic bodies: circles and polygons with any number of sides.\n\nPhysicsLab gives you streamlined functions for making circles, rectangles, polygons, or polygons in random shapes.")
end

function Test_BasicBodies:draw()
    self.lab:draw()
end

function Test_BasicBodies:touched(touch)
    if self.lab:touched(touch) == false then
        if touch.state == BEGAN then
            self.lab:randomPolygonAt(touch.x, touch.y, self.unit * 0.2, self.unit * 0.6)
        end
    end
end

function Test_BasicBodies:collide(contact)
    self.lab:collide(contact)
end

function Test_BasicBodies:cleanup()
    self.lab:clear()
end